<?php
/* --------------------------------------------------------------
 PluginsServiceProvider.php 2020-04-23
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Plugins;

use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\Plugins\Implementation\PluginRegistryService as PluginRegistryServiceImpl;
use Gambio\Core\Application\Plugins\Implementation\PluginsCache;
use Gambio\Core\Application\Plugins\Implementation\PluginsLoader;
use Gambio\Core\Application\Plugins\Utility\DeletePluginRegistry;
use Gambio\Core\Application\Plugins\Utility\DeleteRegistryHandler;
use Gambio\Core\Application\Plugins\Utility\RebuildPluginRegistry;
use Gambio\Core\Application\Plugins\Utility\RebuildRegistryHandler;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractBootableServiceProvider;
use Gambio\Core\Cache\CacheFactory;
use Gambio\Core\Command\Interfaces\CommandHandlerProvider;
use PhpParser\NodeFinder;
use PhpParser\ParserFactory;

/**
 * Class PluginsServiceProvider
 * @package Gambio\Core\Application\Plugins
 */
class PluginsServiceProvider extends AbstractBootableServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            PluginRegistryService::class,
            
            // handler & listener
            RebuildRegistryHandler::class,
            DeleteRegistryHandler::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        /** @var CommandHandlerProvider $provider */
        $provider = $this->application->get(CommandHandlerProvider::class);
        $provider->attachHandler(RebuildPluginRegistry::class, RebuildRegistryHandler::class);
        $provider->attachHandler(DeletePluginRegistry::class, DeleteRegistryHandler::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(PluginRegistryService::class, PluginRegistryServiceImpl::class)
            ->addArgument(PluginsLoader::class)
            ->addArgument(PluginsCache::class);
        
        $this->application->share(PluginsCache::class)->addArgument(CacheFactory::class);
        
        $this->application->share(PluginsLoader::class)
            ->addArgument(Path::class)
            ->addArgument(ParserFactory::class)
            ->addArgument(NodeFinder::class);
        
        $this->application->share(ParserFactory::class);
        $this->application->share(NodeFinder::class);
        $this->application->share(RebuildRegistryHandler::class)->addArgument(PluginRegistryService::class);
        $this->application->share(DeleteRegistryHandler::class)->addArgument(PluginRegistryService::class);
    }
}